<?php
/**
 * Block editor integration class
 */
class Nietos_AI_Editor_Integration {

    /**
     * Enqueue editor assets
     */
    public function enqueue_editor_assets() {
        // Check if plugin is configured
        $settings = new Nietos_AI_Settings();
        if (!$settings->is_configured()) {
            return;
        }

        // Enqueue editor script
        $editor_asset_file = NIETOS_AI_PLUGIN_DIR . 'dist/assets/editor.js';

        if (file_exists($editor_asset_file)) {
            wp_enqueue_script(
                'nietos-ai-editor',
                NIETOS_AI_PLUGIN_URL . 'dist/assets/editor.js',
                array('wp-plugins', 'wp-edit-post', 'wp-element', 'wp-components', 'wp-data'),
                NIETOS_AI_VERSION,
                true
            );

            $editor_style_handle = 'nietos-ai-editor-style';
            $editor_style_file = NIETOS_AI_PLUGIN_DIR . 'dist/assets/editor.css';

            if (file_exists($editor_style_file)) {
                wp_enqueue_style(
                    $editor_style_handle,
                    NIETOS_AI_PLUGIN_URL . 'dist/assets/editor.css',
                    array('wp-components'),
                    NIETOS_AI_VERSION
                );
            } else {
                wp_enqueue_style(
                    $editor_style_handle,
                    NIETOS_AI_PLUGIN_URL . 'admin/css/nietos-admin.css',
                    array('wp-components'),
                    NIETOS_AI_VERSION
                );
            }

            // Get current post data
            global $post;
            $post_context = null;

            if ($post) {
                $post_context = array(
                    'post_id' => $post->ID,
                    'post_title' => $post->post_title,
                    'post_type' => $post->post_type,
                    'post_status' => $post->post_status
                );
            }

            // Localize script
            wp_localize_script('nietos-ai-editor', 'nietosAIEditor', array(
                'restUrl' => rest_url('nietos-ai/v1'),
                'nonce' => wp_create_nonce('wp_rest'),
                'postContext' => $post_context
            ));
        }
    }
}
