/**
 * Nietos AI Settings Page JavaScript
 */
(function($) {
    'use strict';

    /**
     * Update model dropdown with available models
     */
    function updateModelDropdown() {
        const modelSelect = $('#model');
        const models = nietosAiSettings.availableModels || {};
        const currentSelection = modelSelect.val();

        // Clear existing options
        modelSelect.empty();

        // Add new options
        $.each(models, function(modelId, modelName) {
            const isSelected = (currentSelection === modelId) ||
                             (currentSelection === '' && modelId === Object.keys(models)[0]);
            modelSelect.append($('<option>', {
                value: modelId,
                text: modelName,
                selected: isSelected
            }));
        });

        // If current selection doesn't exist, select first option
        if (!models[currentSelection] && Object.keys(models).length > 0) {
            modelSelect.val(Object.keys(models)[0]);
        }
    }

    /**
     * Initialize settings page
     */
    $(document).ready(function() {
        // Initialize dropdowns on page load
        updateModelDropdown();
    });

})(jQuery);
