<?php
/**
 * Ensure block patterns are available for AI
 *
 * This class ensures that theme and WordPress patterns are accessible to AI.
 * It does NOT register custom patterns - it only ensures existing patterns work.
 */
class Nietos_AI_Pattern_Support {

    /**
     * Constructor
     */
    public function __construct() {
        // Log available patterns for debugging
        add_action('init', array($this, 'log_available_patterns'), 999);
    }

    /**
     * Log available patterns for debugging
     */
    public function log_available_patterns() {
        if (!defined('NIETOS_AI_DEBUG') || !NIETOS_AI_DEBUG) {
            return;
        }

        // Check if pattern registry is available
        if (!class_exists('WP_Block_Patterns_Registry')) {
            error_log('Nietos AI: WP_Block_Patterns_Registry class not available');
            return;
        }

        $registry = WP_Block_Patterns_Registry::get_instance();
        $existing_patterns = $registry->get_all_registered();

        error_log('Nietos AI: ' . count($existing_patterns) . ' block patterns are available for AI to use');

        if (count($existing_patterns) > 0) {
            // Log first 5 pattern names for debugging
            $pattern_names = array_keys($existing_patterns);
            $sample_names = array_slice($pattern_names, 0, 5);
            $sample_titles = array();
            foreach ($sample_names as $name) {
                $sample_titles[] = $name . ' (' . ($existing_patterns[$name]['title'] ?? 'No title') . ')';
            }
            error_log('Nietos AI: Sample patterns: ' . implode(' | ', $sample_titles));
        }
    }

}
