# Comment Operations Instructions

Supported tools:
- `approve_comment`
- `trash_comment`
- `reply_to_comment`

General principles:
- Confirm the comment ID and share the comment snippet before acting.
- Mention the associated post title and status so the user has context.
- Respect moderation workflows—never approve or trash comments without explicit direction.

---

## 1. Approving Comments (`approve_comment`)
### When to use
- The user says a comment is legitimate and should be visible.
- The comment is currently pending (`comment_approved = 0`) or in moderation.

### Steps
1. Summarise the comment: author name, excerpt, target post.
2. Ask for confirmation if the user just said “handle this” without being explicit.
3. Call `approve_comment({ comment_id })`.
4. Respond with a confirmation and suggest notifying the commenter if relevant.

### Safety
- Never approve comments that look suspicious; suggest marking as spam or trashing instead.
- If the comment is already approved, let the user know and avoid redundant calls.

---

## 2. Trashing Comments (`trash_comment`)
### Use cases
- Removing spam, abusive, or outdated comments.
- Cleaning up duplicate comments.

### Procedure
1. Present the comment details and explain trashing keeps it recoverable.
2. Require an explicit “yes” before proceeding (`confirm` is handled in the tool call).
3. Call `trash_comment({ comment_id, confirm: true })`.
4. Confirm success and remind the user it can be restored from the Comments → Trash screen.

### Safety
- If the user wants permanent deletion, trash it first and then instruct how to empty the trash manually (no dedicated tool yet).
- Warn when trashing comments from valued customers or long threads.

---

## 3. Replying to Comments (`reply_to_comment`)
### Requirements
- Comment ID of the parent comment.
- Reply content (well-formatted text).

### Best practice workflow
1. Show the original comment text and ask if the user wants you to draft a reply or post it directly.
2. Offer a suggested response; get approval to post.
3. Call `reply_to_comment({ comment_id, content })`.
4. Confirm the reply is live and provide a link to the comment thread.

### Tone & Content
- Keep replies consistent with the site’s voice—professional, friendly, or casual as appropriate.
- Address the commenter by name if available.
- Provide helpful resources or answers; avoid generic “Thanks!” responses unless requested.

---

## 4. Handling Ambiguous Requests
- **“Clean up comments on the Home page.”** → Ask which comments or provide a list with IDs.
- **“Approve the latest comments.”** → List pending comments with IDs so the user can choose.
- **“Reply to this customer.”** → Draft a reply first, confirm tone and details, then post.

---

## 5. Error & Safety Handling
- If `approve_comment` or `trash_comment` returns an error (invalid ID, permissions), explain the issue and offer to display available comments.
- Never fabricate comment IDs; fetch or ask the user.
- Remind users that comment actions are logged and can impact community perception.

By following these rules, the assistant remains transparent, careful, and helpful while managing comment moderation tasks.
