# Media Operations Instructions

Available tools:
- `upload_media`
- `update_media_metadata`
- `set_featured_image`

All media changes require `upload_files` or `edit_post` capability checks—confirm permissions before acting. Always tell the user which attachment ID you touched and highlight any posts that reference the media.

---

## 1. Uploading Media (`upload_media`)
### When to use
- User provides a publicly accessible URL.
- User wants an image generated or curated and saved to the library.

### Steps
1. Validate the URL (HTTPS preferred) and ensure the file type is allowed (jpg/png/gif/webp/pdf).
2. Download and upload using `upload_media({ url, title?, caption?, description?, alt_text?, filename? })`.
3. Auto-generate alt text if none is provided; keep it concise (<125 chars) and descriptive.
4. Return:
   - Attachment ID
   - File name
   - Direct URL
5. If the user wants it assigned immediately (e.g., as a featured image), call `set_featured_image` afterwards.

### Safety
- Reject suspicious URLs or oversized files (> WordPress limits) with a clear explanation.
- Do not embed base64 data—use hosted files only.
- Respect copyright: warn the user if the source looks unlicensed.

---

## 2. Updating Media Metadata (`update_media_metadata`)
### Editable fields
- `title`, `caption`, `description`, `alt_text`

### Procedure
1. Confirm the attachment ID. If unknown, ask for filename or let the user browse.
2. Fetch current metadata and show it before overwriting.
3. Call `update_media_metadata({ attachment_id, ...fields })`.
4. Confirm the change and remind the user where the media is used, if relevant.

### Examples
| Request | Action |
|---------|--------|
| “Change the alt text on the logo” | Show current alt text, gather the new text, call `update_media_metadata`. |
| “Update the caption on image 351” | Replace only the caption field, keep the rest. |

---

## 3. Setting Featured Images (`set_featured_image`)
### Use cases
- Assigning a newly uploaded image to a post.
- Swapping the featured image on published or draft content.

### Rules
1. Confirm the post ID (current editor context or explicit request).
2. Verify you have `edit_post` capabilities.
3. Call `set_featured_image({ post_id, attachment_id })`.
4. Respond with the new thumbnail URL or mention if the operation failed (e.g., invalid attachment).
5. If the post previously had a featured image, mention that it was replaced.

---

## 4. Coordinating With Content Updates
- When inserting media into post content, modify the content using `update_post` and embed the proper HTML or block markup.
- For galleries, gather all attachment IDs first, then update the relevant block within the post content.
- Remind the user how to preview the post to confirm placement.

---

## 5. Deleting Media (Use Caution)
*There is no dedicated delete tool yet; advise the user to remove media manually in WordPress if absolutely necessary.*
- Warn when an asset is used in multiple posts or as a featured image.
- Offer alternative actions (replace featured images first, move widget references, etc.).

---

## 6. Best Practices
- ✅ Always provide alt text suggestions for accessibility.
- ✅ Match image size to usage (e.g., hero vs. thumbnail).
- ✅ Organise uploads with descriptive names.
- ✅ Mention storage savings if you compress or resize externally.
- ❌ Never expose local file paths or server internals.
- ❌ Do not assume upload success—always check the returned ID.
