# Menu Operations Instructions

Tools:
- `create_menu`
- `update_menu`
- `delete_menu`
- `assign_menu_location`
- `add_menu_item`
- `update_menu_item`
- `delete_menu_item`

Menu actions require the `edit_theme_options` capability. Confirm the current user has sufficient permissions before acting. Always reference menus by both name and ID to avoid confusion.

---

## 1. Creating & Renaming Menus
### Creating (`create_menu`)
1. Ask for the menu name (required) and optional slug/description.
2. Clarify if it should immediately be assigned to a theme location.
3. Call `create_menu({ name, slug?, description? })`.
4. Return the new menu ID and suggest assigning it to a location or adding items.

### Renaming (`update_menu`)
1. Confirm the menu ID (offer to list menus if the user only knows the label).
2. Gather the new name/slug/description.
3. Call `update_menu({ menu_id, name?, slug?, description? })`.
4. Mention that the menu now appears under the new name in WordPress → Appearance → Menus.

---

## 2. Assigning Menus to Theme Locations (`assign_menu_location`)
### Steps
1. List available theme locations if the user is unsure (`primary`, `footer`, etc.).
2. Warn when replacing a menu already assigned to that location.
3. Call `assign_menu_location({ menu_id, location })`.
4. Confirm the placement and note that some themes cache menu output (refresh may be needed).

---

## 3. Managing Menu Items
### Adding (`add_menu_item`)
Gather:
- Menu ID
- Label (`title`)
- Item type:
  - Custom URL (`type: 'custom'` + `url`)
  - Post/page (`type: 'post_type'` + `object_id` + `object`)
  - Term/category (`type: 'taxonomy'` + `object_id` + `object`)
- Optional parent item ID and position

Call `add_menu_item({ menu_id, title, type, url?, object_id?, object?, parent_id?, position? })`.

### Updating (`update_menu_item`)
Use for label changes, URL updates, restructuring:
```
update_menu_item({ menu_id, item_id, title?, url?, parent_id?, position? })
```
Confirm new placement (“Item now appears under ‘Services’ as the second entry.”).

### Deleting (`delete_menu_item`)
- Summarise the item and any children it may have.
- Ask for explicit confirmation.
- Call `delete_menu_item({ menu_id, item_id, confirm: true })`.
- Warn that child items are also removed.

---

## 4. Deleting Entire Menus (`delete_menu`)
1. Identify the menu and list where it is currently used.
2. Ask whether items should be recreated elsewhere or backed up first.
3. Require confirmation: *“Delete menu ‘Footer Links’ (ID 9)? This removes all its items.”*
4. Call `delete_menu({ menu_id, confirm: true })`.

---

## 5. Handling Ambiguous Requests
- “Swap the main menu” → Identify both menus, confirm which location is “main,” then assign.
- “Mirror the footer menu in the sidebar” → Create or assign the same items through `add_menu_item` or duplicate as needed.
- “Reorder the navigation” → Ask for the desired order, then update `position` for each item sequentially.

---

## 6. Safety & Best Practices
- ✅ Provide previews (list menu items) before major changes.
- ✅ Maintain hierarchy by preserving parent/child relationships.
- ✅ Use append positions carefully; if the user wants a specific order, gather it explicitly.
- ✅ Mention if menus are cached (e.g., full-site editing themes) and suggest clearing caches.
- ❌ Don’t remove menus that are still assigned without warning.
- ❌ Don’t guess IDs; list available menus/locations when unsure.
- ❌ Avoid creating duplicate menu items unless the user insists (e.g., same link appearing in multiple sections).

These steps keep navigation changes predictable and reversible, giving site owners confidence that their menus stay organised.
