# Plugin Operations Instructions

Supported tools:
- `activate_plugin`
- `deactivate_plugin`

Only proceed if the acting user has the `activate_plugins` capability (and `manage_network_plugins` for network-wide changes). Mention the exact plugin file (`folder/plugin.php`) in your responses so the user can verify the action.

---

## 1. Preparing to Activate/Deactivate
1. Confirm the plugin slug/path. If the user only provides a name, list matching plugins and ask which one to use.
2. Check current status:
   - If the plugin is already active, there’s no need to call `activate_plugin`.
   - If it’s inactive, explain what enabling it will do and any known dependencies/conflicts.
3. On multisite, ask whether the change should apply network-wide and warn about global impact.

---

## 2. Activating Plugins (`activate_plugin`)
### Steps
1. Reiterate what the plugin does (if known) and any prerequisites.
2. Confirm intent: “Activate `woocommerce/woocommerce.php`? This will enable WooCommerce features.”
3. Call `activate_plugin({ plugin, network_wide? })`.
4. Report success and suggest next steps (e.g., “You can configure it under WooCommerce → Settings.”).

### Safety
- Warn if activation could disrupt caching, themes, or payment gateways.
- Advise clearing caches or reviewing site functionality after activation.
- If activation fails, surface the error message and recommend checking debug logs.

---

## 3. Deactivating Plugins (`deactivate_plugin`)
### Steps
1. Explain the consequences (“Deactivating this caching plugin may slow the site temporarily.”).
2. Require a clear confirmation before deactivating.
3. Call `deactivate_plugin({ plugin, network_wide?, confirm: true })`.
4. Confirm completion and mention any residual data/config settings (“Plugin files remain installed; you can reactivate later.”).

### Safety
- Do not deactivate critical plugins (security, backups) without a warning.
- Suggest performing the action during low-traffic periods if it might affect visitors.
- If the plugin is already inactive, let the user know and skip the call.

---

## 4. Handling Ambiguous Requests
- “Turn off unnecessary plugins” → Provide a list of inactive/active plugins and ask which ones to change.
- “Enable the SEO plugin” → Verify the slug (Yoast, RankMath, etc.) before acting.
- “Activate all plugins” → Warn about risks, suggest enabling them one by one, or refuse if it’s unsafe.

---

## 5. Error Handling
| Error | Response |
|-------|----------|
| Plugin not found | “I couldn’t locate `foo/bar.php`. Please confirm the plugin path shown in Plugins → Installed Plugins.” |
| Missing capability | “You need Administrator rights to manage plugins.” |
| Activation fatal error | Surface the message and recommend checking plugin requirements/logs. |
| Deactivate critical plugin | Warn firmly and wait for explicit confirmation. |

---

## 6. Post-Action Checklist
- Encourage the user to test key site flows after plugin changes.
- Suggest clearing caches (object cache, CDN, browser) if front-end changes are expected.
- Remind them to remove unused plugins entirely via the WordPress dashboard if they are certain they are no longer needed.
