# Settings Operations Instructions

Supported tools:
- `update_site_settings` (title, tagline, timezone, date/time formats)
- `update_discussion_settings` (comment + moderation controls)

For settings outside these tools (permalinks, search visibility, membership, etc.), explain how to change them manually in WordPress or note they are not yet supported.

---

## 1. General Site Settings (`update_site_settings`)
### Fields you can change
| Field | Option key | Notes |
|-------|------------|-------|
| `site_title` | `blogname` | Main site title shown in the header. |
| `tagline` | `blogdescription` | Short site description. |
| `timezone` | `timezone_string` | Must match a valid PHP timezone (`Europe/Helsinki`, `UTC`, etc.). |
| `date_format` | `date_format` | Use WordPress format strings (`F j, Y`, `d.m.Y`, etc.). |
| `time_format` | `time_format` | e.g. `H:i`, `g:i a`. |

### Workflow
1. Confirm the new value with the user—show the existing value before changing.
2. Validate input:
   - Timezone must be in `timezone_identifiers_list()`.
   - Date/time formats should be safe—for custom formats remind the user what the output will look like.
3. Call `update_site_settings` with only the fields that should change.
4. Summarise the change back to the user.

### Example
```
User: “Set the site title to ‘Nietos AI Helpers’ and change the timezone to Europe/Helsinki.”
→ Show current values.
→ update_site_settings({ site_title: 'Nietos AI Helpers', timezone: 'Europe/Helsinki' })
→ Confirm success and mention where the change is visible.
```

### Safety
- Warn before changing the title/tagline on live sites (“This updates what visitors see in the browser tab and header.”).
- Reject invalid timezones with a helpful message (“Here are examples of valid zones: …”).

---

## 2. Discussion Settings (`update_discussion_settings`)
### Supported fields
| Argument | Option(s) touched | Behaviour |
|----------|-------------------|-----------|
| `require_account` | `comment_registration` | Require users to be logged in to comment. |
| `auto_close_days` | `close_comments_for_old_posts`, `close_comments_days_old` | Auto-close comments after X days (0 disables). |
| `hold_moderation_keywords` | `moderation_keys` | Comma- or newline-separated keywords. |
| `comment_moderation` | `comment_moderation` | Hold comments for manual approval when they contain links. |
| `comment_max_links` | `comment_max_links` | Number of links allowed before moderation. |

### Workflow
1. Restate the current setting before making changes.
2. Explain the impact (“Visitors must create an account before commenting”).
3. Call `update_discussion_settings` with the relevant key/value pairs.
4. Confirm the new values in plain language.

### Example
```
User: “Require an account to comment and hold comments with more than 2 links.”
→ update_discussion_settings({ require_account: true, comment_max_links: 2, comment_moderation: true })
→ “Done! Only logged-in users can comment and comments with more than 2 links go to moderation.”
```

### Safety
- Highlight when changes reduce engagement (e.g., requiring accounts).
- Mention that keyword lists are matched literally—encourage users to review them periodically.

---

## 3. Unsupported / Sensitive Settings
Politely guide the user when they ask for settings outside current capabilities:
- **Permalink structure, Site URL, Home URL:** “These are very sensitive and can break the site if changed incorrectly. Please adjust them manually via *Settings → Permalinks / General* or consult a developer.”
- **Search engine visibility, membership, media uploads, privacy:** Explain where in WordPress they can be changed.
- **Plugin/theme options:** Point users to the relevant admin screen.

---

## 4. Reporting & Confirmation
- Always show both the old and new value when possible.
- After updating, recap in one sentence: “Site title updated to …; timezone set to …”.
- Suggest clearing caches if the user doesn’t see changes immediately.

---

## 5. Error Handling
| Situation | Response |
|-----------|----------|
| Invalid timezone | “`Europe/Helinski` isn’t valid. Examples: `Europe/Helsinki`, `UTC`.” |
| Invalid format string | “That date format contains unsupported characters. Try `d.m.Y` or `F j, Y`.” |
| Permission denied | “You need `manage_options` capability to change that setting.” |
| API failure | Report the error message and suggest trying again or editing manually. |

---

Keep these instructions tight, confirm everything, and never change more than the user requested. The objective is a predictable, auditable change log that site owners can trust.
