# Taxonomy Operations Instructions

Tools:
- `create_term`
- `update_term`
- `delete_term`
- `assign_terms_to_post`

Taxonomies include categories (`category`), tags (`post_tag`), and any custom taxonomies registered by the theme/plugins. Always check which taxonomy the user means.

---

## 1. Creating Terms (`create_term`)
### Information to gather
- Taxonomy (`category`, `post_tag`, etc.). Default to `category` if the user says “category”, otherwise ask.
- Term name (required).
- Optional: slug, description, parent (only for hierarchical taxonomies such as categories or product categories).

### Steps
1. Confirm the taxonomy exists via `get_taxonomy` (handled in the tool).
2. Ensure the name is unique—if a similar term exists, ask whether to reuse or create a variant.
3. Call `create_term({ taxonomy, name, slug?, description?, parent? })`.
4. Return the new term ID and remind the user they can assign it to posts immediately.

### Safety
- For hierarchical parents, validate the parent term first (ask the user for the ID or name).
- Warn when creating administrator-only terms (e.g., membership level taxonomies).

---

## 2. Updating Terms (`update_term`)
### Editable fields
- Name (rename the term)
- Slug (URL fragment)
- Description
- Parent (for hierarchical taxonomies)

### Workflow
1. Confirm term ID and taxonomy. Offer a lookup if the user only knows the name.
2. Show current values before changing.
3. Ask before altering slugs on live sites (changing URLs can affect SEO).
4. Call `update_term({ term_id, taxonomy?, name?, slug?, description?, parent? })`.
5. Confirm the update and suggest reviewing posts that use the term to ensure copy still matches.

---

## 3. Deleting Terms (`delete_term`)
### Procedure
1. Identify the term (ID + name) and taxonomy.
2. Count how many posts currently use it. Warn the user that those posts will lose the term assignment.
3. Require `confirm: true`.
4. Call `delete_term({ term_id, taxonomy, confirm })`.
5. After deletion, list any posts that might need new categorisation.

### Safety
- Offer alternatives like merging with another term (create + reassign) instead of outright deletion.
- Do not delete default categories unless the user has another default ready.

---

## 4. Assigning Terms to Posts (`assign_terms_to_post`)
### When to use
- Adding/removing categories or tags on a post/page.
- Replacing all tags with a new curated list.
- Appending a “featured” tag to multiple posts (do one at a time).

### Required data
- `post_id`
- `term_ids` (array of IDs)
- `taxonomy` (defaults to `category` if omitted)
- `append` (`true` to add to existing terms, `false` to replace)

### Rules
1. Confirm the target post.
2. If the user provides term names, resolve them to IDs first (offer to create missing terms).
3. Explain the difference between appending and replacing:
   - Append keeps existing terms.
   - Replace removes all current terms in that taxonomy before adding the new ones.
4. Call `assign_terms_to_post({ post_id, taxonomy, term_ids, append })`.
5. Summarise the resulting term list for the post.

---

## 5. Quick Examples
| Request | Action | Tool |
|---------|--------|------|
| “Add a ‘Case Studies’ category” | Create new `category` term | `create_term` |
| “Rename ‘News’ category to ‘Company News’” | Update term name & slug | `update_term` |
| “Delete the ‘Archive’ tag” | Confirm usage count, delete | `delete_term` |
| “Tag this post with ‘Updates’ and ‘Announcements’” | Resolve term IDs (create if missing) and assign | `assign_terms_to_post` |

---

## 6. Safety & Error Handling
- ✅ Confirm before deleting or overwriting slugs.
- ✅ Provide counts/impacts when removing terms.
- ✅ Sanitize names and slugs (lowercase, hyphenated).
- ❌ Never assign taxonomy terms to a post type that doesn’t support them.
- ❌ Don’t create duplicate terms unless the user insists.
- If a tool fails (invalid taxonomy/term ID), explain and offer to list available terms for clarity.
