# User Management Instructions

Core tools:
- `create_user`
- `update_user`
- `change_user_role`
- `delete_user`

Only proceed if the acting user has the required capability (`create_users`, `edit_users`, `promote_user`, `delete_users`). Always verify and narrate the safety implications.

---

## 1. Creating Users (`create_user`)
### Required inputs
- Email address (must be unique and valid)
- Role (default to the site’s `default_role` if not specified, but confirm first)
- Username (can auto-generate from email/name if missing)
- Optional: first name, last name, display name, password

### Checklist
1. Ask for missing required data. Never guess email addresses.
2. Validate role availability. If unsure, list the standard roles.
3. Warn when creating privileged users (Editor, Administrator).
4. If no password is supplied, generate a secure one—return it only if the user explicitly asks.
5. Call `create_user` and report back with user ID, username, and role. Mention that a password reset email is sent if applicable.

### Quick Example
```
User: “Create an editor for Sarah (sarah@example.com).”
→ Confirm email/role.
→ create_user({ username, email, role: 'editor', first_name?, last_name?, display_name? })
→ “Created user ‘sarah’ (Editor). Ask Sarah to check her email for the password setup link.”
```

---

## 2. Updating Profiles (`update_user`)
### Safe fields to edit
- `email`, `first_name`, `last_name`, `display_name`, `password`

### Rules
1. Confirm you have the target user ID (offer a lookup by username/email if needed).
2. For email changes, mention that WordPress will send confirmation messages.
3. Do not reveal passwords. If a new password is set, encourage the user to send a reset email afterward.
4. Changing sensitive info for higher-privilege accounts? Warn the requester and confirm.

---

## 3. Changing Roles (`change_user_role`)
### Safety
- Never demote the only administrator.
- Prevent users from upgrading someone above their own capability level.
- Confirm any promotion that increases publishing power or admin access.

### Flow
1. Identify current role and content impact.
2. Explain the new capabilities gained/lost.
3. Ask for confirmation.
4. Call `change_user_role({ user_id, role })`.
5. Confirm completion with the new role.

---

## 4. Deleting Users (`delete_user`)
### Mandatory confirmation steps
1. Summarise the user: username, email, role, post/comment counts.
2. Ask whether to reassign content (`reassign_to`) or delete it.
3. Explicitly require `confirm: true`.
4. Prevent deleting the currently logged-in user or the last administrator.

### Response example
```
“Delete user ‘johndoe’ (Author, 18 posts)? Options:
- Reassign their content to another user (recommended)
- Delete their content as well (irreversible)”
```

---

## 5. Discovering Users (No Dedicated Tool)
If the user wants to search or list accounts:
- Offer to filter by role or email and present results manually.
- Redact sensitive details—show username, email, role, published post counts.
- Remind them they can browse the WordPress Users screen for more detail.

---

## 6. Capability Matrix
| Action | Required capability |
|--------|---------------------|
| create_user | `create_users` |
| update_user | `edit_user` (target user) |
| change_user_role | `promote_user` |
| delete_user | `delete_users` |

If the current user lacks a capability, stop and explain the permission issue.

---

## 7. Safety Quick Reference
- ✅ Confirm before elevating privileges.
- ✅ Reassign content when deleting authors.
- ✅ Always require `confirm: true` for destructive actions.
- ✅ Log or mention that a password reset email was sent.
- ❌ Never expose passwords or password hashes.
- ❌ Never delete the last administrator.
- ❌ Never modify users with a higher role than the requester.

Following these guardrails keeps accounts secure and audit trails clean. Always recap what you did and supply next steps (e.g., “Ask the new user to check their inbox”).
