# Widget Operations Instructions

Tools:
- `create_widget`
- `update_widget`
- `delete_widget`
- `assign_widget_to_sidebar`

Widget changes require `edit_theme_options`. Confirm capabilities before acting. Always refer to widgets by their full IDs (e.g., `text-3`) and sidebars by ID (`sidebar-1`, `footer-1`, `wp_inactive_widgets`).

---

## 1. Creating Widgets (`create_widget`)
### Gather before calling
- `id_base` (widget type, e.g., `text`, `custom_html`, `search`, `nav_menu`).
- Settings payload (title, content, etc.).
- Optional sidebar ID and desired position.

### Steps
1. Validate the widget type exists. If not, suggest alternatives.
2. Clarify where the widget should appear. If unsure, place it in the inactive area.
3. Call `create_widget({ id_base, settings?, sidebar_id?, position? })`.
4. Return the new widget ID and location.

### Best Practices
- For text/HTML widgets, confirm the copy with the user before saving.
- For navigation/menu widgets, make sure the requested menu exists first.
- When adding multiple widgets, communicate the order in which they’ll appear.

---

## 2. Updating Widgets (`update_widget`)
### Rules
1. Confirm the widget exists; list current settings so the user can review them.
2. Only change the fields the user requested.
3. Retain other settings to avoid wiping out configuration (e.g., CSS classes).
4. Call `update_widget({ widget_id, settings })` with a fully merged settings object.
5. Summarise the new content/settings and mention the sidebar it affects.

### Example
```
User: “Change the footer text widget to show our new address.”
→ Show current text.
→ update_widget({ widget_id: 'text-4', settings: { title: 'Contact', text: '<p>New address…</p>' } })
→ “Updated widget text-4 in sidebar footer-1.”
```

---

## 3. Deleting Widgets (`delete_widget`)
### Procedure
1. Identify the widget and where it sits.
2. Warn that deletion removes both configuration and placement.
3. Offer alternatives:
   - Move to inactive widgets (`assign_widget_to_sidebar` with `sidebar_id: 'wp_inactive_widgets'`).
4. Require an explicit “yes” before calling `delete_widget({ widget_id, confirm: true })`.
5. Confirm completion.

---

## 4. Moving / Assigning Widgets (`assign_widget_to_sidebar`)
### Use cases
- Moving a widget between sidebars.
- Reordering widgets within the same sidebar.
- Parking widgets in the inactive area.

### Steps
1. Collect `widget_id`, `sidebar_id`, optional `position`.
2. Remind the user of the resulting order (e.g., “Placed after ‘Latest Posts’ in sidebar-1”).
3. Call `assign_widget_to_sidebar({ widget_id, sidebar_id, position? })`.
4. Confirm the new placement.

---

## 5. Handling Ambiguous Requests
- “Show something new in the sidebar.” → Ask if they want to create a new widget, update an existing one, or rearrange.
- “Clean up footer widgets.” → List current widgets/IDs first, then ask which ones to remove or move.
- “Duplicate this widget.” → Explain that duplication requires creating a new widget with the same settings.

---

## 6. Safety & Error Handling
- ✅ Always provide the widget ID and sidebar names in confirmations.
- ✅ Sanitize HTML content using `wp_kses_post` equivalence; reject unsafe scripts.
- ✅ Respect theme-specific sidebars—warn if a requested sidebar does not exist.
- ❌ Do not assume widget IDs—fetch or list them when unclear.
- ❌ Avoid deleting multiple widgets at once without a summary of what will disappear.
- If a tool returns an error (unknown widget, invalid sidebar), explain it and offer to display valid options.

Deliver clear, reversible changes by keeping users informed about widget placements and content.
