<?php
/**
 * Uninstall script for Nietos AI
 *
 * This file is executed when the plugin is deleted via WordPress admin.
 * It removes all plugin data from the database.
 */

// Exit if accessed directly or not from WordPress uninstaller
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Delete all plugin options
 */
delete_option('nietos_ai_settings');
delete_option('nietos_ai_db_version');
delete_option('nietos_ai_license_key');
delete_option('nietos_ai_api_validated');
delete_transient('nietos_ai_license_status');
delete_transient('nietos_ai_models_openai');

/**
 * Delete all user meta data
 */
global $wpdb;

// Delete message count user meta
$wpdb->query("DELETE FROM {$wpdb->usermeta} WHERE meta_key = 'nietos_ai_message_count'");

/**
 * Clear any caches
 */
wp_cache_flush();
